# 機能設計書 22-Route Groups

## 概要

本ドキュメントは、Next.js App RouterにおけるRoute Groups機能の設計を記述する。Route Groupsは、`(folderName)`形式の括弧付きフォルダ名によりルートを論理的にグループ化する仕組みであり、URLパスに影響を与えずにルートの整理やレイアウトの共有範囲を制御できる。

### 本機能の処理概要

**業務上の目的・背景**：大規模なアプリケーションでは、ルート数が増加するにつれてファイル構造の整理が必要になる。また、特定のルートグループにのみ共通レイアウトを適用したい場合がある。Route Groupsは、URLパス構造に影響を与えることなく、ファイルシステム上のルートを論理的にグループ化し、レイアウトの適用範囲を柔軟に制御するために必要な機能である。

**機能の利用シーン**：マーケティングページとアプリケーションページで異なるレイアウトを適用するケース（例：`(marketing)/about`と`(app)/dashboard`）。認証が必要なルートと公開ルートでグループ分けするケース。チーム別のコード管理単位としてルートを整理するケースなど。

**主要な処理内容**：
1. ファイルシステムスキャン時の括弧付きフォルダの検出
2. パス正規化時のRoute Groupセグメント除外（URLパスから除去）
3. レイアウト階層構造でのRoute Group単位のレイアウト適用
4. ビルド時のルートバリデーション（Route Group間での重複パス検出）

**関連システム・外部連携**：App Routerのルーティングシステム、レイアウト機能、ビルドシステムと密接に連携する。

**権限による制御**：特になし。ファイルシステム構造に基づく静的な機能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Route GroupsはURLパスに影響しないため画面機能マッピングに直接の関連はないが、レイアウト構造に影響を与える |

## 機能種別

ルーティング制御 / ファイルシステム構造管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| フォルダ名 | string | Yes | `(groupName)`形式のフォルダ名 | 括弧で囲まれた英数字とハイフン |
| appPath | string | Yes | App Router内のファイルパス | Route Groupセグメントを含みうるパス |

### 入力データソース

- ファイルシステム上のappディレクトリ構造

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| normalizedPath | string | Route Groupセグメントが除外された正規化パス |
| layoutTree | LoaderTree | Route Group内のレイアウト階層を含むローダーツリー |

### 出力先

- ルーティングマニフェスト（Route Groupセグメントを除去したURLパス）
- レイアウトツリー（Route Group固有のレイアウトを含む階層構造）

## 処理フロー

### 処理シーケンス

```
1. ファイルシステムスキャン
   └─ appディレクトリを再帰的にスキャンし、括弧付きフォルダを検出
2. Route Groupの判定
   └─ フォルダ名が(...)形式であるかを正規表現で判定
3. パス正規化
   └─ normalizeAppPathでRoute Groupセグメントを除去
4. レイアウトツリー構築
   └─ Route Group内のlayout.tsxをレイアウト階層に組み込み
5. ルートバリデーション
   └─ 異なるRoute Group間で同一URLパスが発生していないかチェック
```

### フローチャート

```mermaid
flowchart TD
    A[ファイルスキャン開始] --> B{フォルダ名が括弧で囲まれている?}
    B -->|Yes| C[Route Groupとして認識]
    B -->|No| D[通常セグメントとして処理]
    C --> E[URLパスからRoute Groupセグメントを除外]
    C --> F[Route Group内のlayout.tsxを検出]
    E --> G[正規化パスを生成]
    F --> H[レイアウト階層に組み込み]
    G --> I{他のRoute Groupと重複するパスがあるか?}
    I -->|Yes| J[ビルドエラーを報告]
    I -->|No| K[ルートマニフェストに登録]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | URL非影響 | Route Groupのフォルダ名はURLパスに含まれない | 常時 |
| BR-22-02 | レイアウト分離 | 異なるRoute Group内のlayout.tsxは互いに独立 | Route Group内にlayout.tsxが存在する場合 |
| BR-22-03 | 重複パス禁止 | 異なるRoute Groupが同一のURLパスを生成してはならない | ビルド時のバリデーション |
| BR-22-04 | ルートレイアウト複数定義 | 各Route Groupに独自のルートレイアウトを持てるが、最上位のlayout.tsxは1つのみ | ルートレベルのRoute Group使用時 |

### 計算ロジック

パス正規化ロジック：`/(marketing)/about/page.tsx` -> `/about`

`normalizeAppPath`関数が括弧付きセグメントを除去し、連続する`/`を正規化する。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし。Route Groupsはファイルシステムベースのルーティング機能であり、データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 重複ルートエラー | 異なるRoute Groupが同一URLパスを生成 | Route Group構造を見直し、重複しないパスにする |
| - | レイアウト競合 | 同一パスに複数のRoute Groupからレイアウトが適用される | レイアウト構造を再設計する |

### リトライ仕様

該当なし。ビルド時のバリデーションエラーは開発者による修正が必要。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- Route Groupsはビルド時に解決されるため、ランタイムのパフォーマンスへの影響はない
- パス正規化処理は文字列操作のみで高速

## セキュリティ考慮事項

- Route Groupのフォルダ名はURLに露出しないため、内部的なコード構造が外部に漏洩しない

## 備考

- Route Groupsは主にコードの整理とレイアウト制御のために使用される
- 並列ルート（Parallel Routes）やインターセプトルートと組み合わせて使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Route Groupの判定とパス正規化のロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | app-paths.ts | `packages/next/src/shared/lib/router/utils/app-paths.ts` | `normalizeAppPath`でRoute Groupセグメントが除去される処理 |

**読解のコツ**: `normalizeAppPath`関数は括弧付きセグメント（Route Group）とPage Segment Key（`__PAGE__`）を除去してURLパスを生成する。

#### Step 2: ファイルシステムスキャンを理解する

ビルド時のファイルシステムスキャンでRoute Groupsがどのように処理されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | next-app-loader/index.ts | `packages/next/src/build/webpack/loaders/next-app-loader/index.ts` | appディレクトリのスキャンでRoute Groupが検出されレイアウトツリーに組み込まれる処理 |
| 2-2 | filesystem.ts | `packages/next/src/server/lib/router-utils/filesystem.ts` | ファイルシステムルーターでのRoute Group処理 |

#### Step 3: バリデーションを理解する

ビルド時のルートパス重複バリデーション。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | validate-app-paths.ts | `packages/next/src/build/validate-app-paths.ts` | Route Group間のパス重複を検出するバリデーションロジック |

### プログラム呼び出し階層図

```
next build [src/build/index.ts]
    |
    +-- ファイルシステムスキャン
    |       +-- isGroupSegment() 判定
    |       +-- Route Group内のlayout.tsx検出
    |
    +-- normalizeAppPath() [src/shared/lib/router/utils/app-paths.ts]
    |       +-- Route Groupセグメント除去
    |
    +-- validateAppPaths() [src/build/validate-app-paths.ts]
            +-- 正規化パスの重複チェック
```

### データフロー図

```
[入力]                    [処理]                          [出力]

app/(marketing)/          normalizeAppPath()              /about (URL)
  about/page.tsx    ──>   Route Group除去           ──>   レイアウトツリー
                          レイアウト階層構築               ルートマニフェスト

app/(app)/                normalizeAppPath()              /dashboard (URL)
  dashboard/page.tsx ──>  Route Group除去           ──>   レイアウトツリー
                          レイアウト階層構築               ルートマニフェスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| app-paths.ts | `packages/next/src/shared/lib/router/utils/app-paths.ts` | ソース | パス正規化（Route Group除去） |
| validate-app-paths.ts | `packages/next/src/build/validate-app-paths.ts` | ソース | ルートパス重複バリデーション |
| validate-app-paths.test.ts | `packages/next/src/build/validate-app-paths.test.ts` | テスト | バリデーションのテスト |
| next-app-loader/index.ts | `packages/next/src/build/webpack/loaders/next-app-loader/index.ts` | ソース | appディレクトリスキャンとローダーツリー構築 |
| filesystem.ts | `packages/next/src/server/lib/router-utils/filesystem.ts` | ソース | ファイルシステムルーターのRoute Group処理 |
| app-dir-module.ts | `packages/next/src/server/lib/app-dir-module.ts` | ソース | App DirectoryモジュールのRoute Groupセグメント処理 |
| verify-root-layout.ts | `packages/next/src/lib/verify-root-layout.ts` | ソース | ルートレイアウトの検証 |
